//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Diagnostics;

namespace Bench
{
	/// <summary>
	/// Podsumowanie dla NetworkTest.
	/// </summary>
	public abstract class NetworkTest
	{
		public NetworkTest(string server, int port, int numberOfPackets, int packetSize)
		{
			this.server = server;
			this.port = port;
			this.numberOfPackets = numberOfPackets;
			this.packetSize = packetSize;
			elapsed = 0.0F;
			transmitByteCount = 0;
			receivedByteCount = 0;

			PerformanceCounterCategory pcCategory = new PerformanceCounterCategory("Network Interface");
			instanceNames = pcCategory.GetInstanceNames();

			performanceCounters = new PerformanceCounter[instanceNames.Length];
			startCounterValues = new float[instanceNames.Length];
			stopCounterValues = new float[instanceNames.Length];
			result = new float[instanceNames.Length];
			for(int i = 0; i < instanceNames.Length; i++)
			{
				performanceCounters[i] = new PerformanceCounter("Karta sieciowa", "Bajtw/s", instanceNames[i]);
			}
		}
		public abstract void Start();
		public string Server
		{
			get
			{
				return server;
			}
		}
		public int Port
		{
			get
			{
				return port;
			}
		}
		public int NumberOfPackets
		{
			get
			{
				return numberOfPackets;
			}
		}
		public int PacketSize
		{
			get
			{
				return packetSize;
			}
		}
		public string [] InstanceNames
		{
			get
			{
				return instanceNames;
			}
		}
		public int TransmitByteCount
		{
			get
			{
				return transmitByteCount;
			}
			set
			{
				transmitByteCount = value;
			}
		}
		public int ReceivedByteCount
		{
			get
			{
				return receivedByteCount;
			}
			set
			{
				receivedByteCount = value;
			}
		}
		public float Elapsed
		{
			get
			{
				return elapsed;
			}
			set
			{
				elapsed = value;
			}
		}
		public float [] Rate
		{
			get
			{
				return result;
			}
		}
		public void StartCounters()
		{
			for(int i = 0;i < startCounterValues.Length;i++)
			{
				startCounterValues[i] = performanceCounters[i].NextValue();
			}
		}
		public void StopCounters()
		{
			for(int i = 0;i < stopCounterValues.Length;i++)
			{
				stopCounterValues[i] = performanceCounters[i].NextValue();
				result[i] = stopCounterValues[i];
			}
		}
		private string server;
		private int port;
		private int numberOfPackets;
		private int packetSize;
		private int transmitByteCount;
		private int receivedByteCount;
		private float elapsed;
		string [] instanceNames;
		PerformanceCounter [] performanceCounters;
		float [] startCounterValues;
		float [] stopCounterValues;
		float [] result;
	}
}
